import xml.etree.ElementTree as ET
import http.client
import base64
import ssl
import tempfile
import os
from urllib.parse import urlparse

class wpClass:
	def initialize(self, lzUrl):
		uparse = urlparse(lzUrl)
		if uparse.scheme == 'https':
			self.https = True
			self.port = 443 if uparse.port == None else int(uparse.port)
		else:
			self.https = False
			self.port = 80 if uparse.port == None else int(uparse.port)
		self.server = uparse.netloc
		self.location = uparse.path
		self.domd = None

	def sendRequest(self, envelope):
		if self.https:
			cnn = http.client.HTTPSConnection(self.server, self.port, context = ssl._create_unverified_context())
		else:
			cnn = http.client.HTTPConnection(self.server, self.port)
		hdr = {'Content-type': 'application/x-www-form-urlencoded'}
		cnn.request('POST', self.location, envelope, hdr);
		response = cnn.getresponse();
		result = response.read().decode('utf-8')
		if response.status == 200:
			self.domd = domCross(ET.fromstring(result))
			risposta = "OK"
		else:
			risposta = "Errore: " + str(response.status) + " " + response.reason + "\n" + result
		cnn.close()
		return risposta

	def sendFile(self, nomeFile, envelope):
		with open(nomeFile, "rb") as binaryfile:
			binData = binaryfile.read()
		b64Data = base64.b64encode(binData)
		if self.https:
			cnn = http.client.HTTPSConnection(self.server, self.port, context = ssl._create_unverified_context())
		else:
			cnn = http.client.HTTPConnection(self.server, self.port)
		hdr = {'Content-type': 'application/x-www-form-urlencoded'}
		wsurl = self.location + envelope
		cnn.request('PUT', wsurl, b64Data, hdr);
		response = cnn.getresponse();
		result = response.read().decode('utf-8')
		if response.status == 200:
			#root = ET.fromstring(result)
			#risposta = root[0].text
			self.domd = domCross(ET.fromstring(result))
			risposta = "OK"
		else:
			risposta = "Errore: " + str(response.status) + " " + response.reason + "\n" + result
		cnn.close()
		return risposta

class domCross:
	def __init__(self, radice):
		self.root = radice
		self.nodo = None
		self.subObj = None
		self.indice = 0

	def startElement(self):
		if self.subObj:
			self.subObj.startElement()
		else:
			self.subObj = domCross(self.nodo)

	def nextElement(self, deep = 0):
		if self.subObj:
			deep = deep + 1
			status = self.subObj.nextElement(deep)
			if status > 0:
				self.subObj = None
				status = 0
		else:
			if self.indice < len(self.root):
				self.nodo = self.root[self.indice]
				self.indice = self.indice + 1
				status = -1
			else:
				status = deep
		return status

	def restart(self):
		self.nodo = None
		self.subObj = None
		self.indice = 0

	def elementName(self):
		if self.subObj:
			return self.subObj.elementName()
		else:
			return self.nodo.tag

	def elementValue(self):
		if self.subObj:
			return self.subObj.elementValue()
		else:
			return self.nodo.text

	def elementAttribute(self, attrName):
		if self.subObj:
			return self.subObj.elementAttribute(attrName)
		else:
			return self.nodo.get(attrName, "")

	def elementCount(self):
		if self.subObj:
			return self.subObj.elementCount()
		elif self.nodo:
			return len(self.nodo)
		else:
			return len(self.root)

	def childValue(self, childName):
		result = ""
		for element in self.root:
			if element.tag == childName:
				result = element.text
				break
		return result

def lwpCross(azione, attributo = None):
	if azione == 0:
		return wpo.domd.nextElement()
	elif azione == 1:
		return wpo.domd.elementName()
	elif azione == 2:
		return wpo.domd.elementValue()
	elif azione == 3:
		return wpo.domd.elementAttribute(attributo)
	elif azione == 4:
		return wpo.domd.startElement()
	elif azione == 5:
		return wpo.domd.elementCount()
	elif azione == 6:
		return wpo.domd.restart()
	return False

def lwpInit(gwpUrl):
	wpo.initialize(gwpUrl)
	return True

def lwpSend(envelope):
	return wpo.sendRequest(envelope)

def lwpParam(tagName):
	return wpo.domd.childValue(tagName)

def lwpSendFile(filename, envelope):
	return wpo.sendFile(filename, envelope)

def lwpBR64(stringa, modo):
	if modo:
		result = base64.b64decode(stringa[::-1])
	else:
		string_bytes = stringa.encode('ascii')
		base64_bytes = base64.b64encode(string_bytes)
		base64_string = base64_bytes.decode('ascii')
		result = base64_string[::-1]
	return result

def lwpPaths(azione):
	if azione == 0:
		if os.name == 'nt':
			return '\\'
		else:
			return '/'
	elif azione == 1:
		return tempfile.gettempdir()
	elif azione == 2:
		if os.name == 'nt':
			import winreg
			sub_key = r'SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders'
			downloads_guid = '{374DE290-123F-4565-9164-39C4925E467B}'
			with winreg.OpenKey(winreg.HKEY_CURRENT_USER, sub_key) as key:
				location = winreg.QueryValueEx(key, downloads_guid)[0]
			return location
		else:
			return os.path.join(os.path.expanduser('~'), 'downloads')

wpo = wpClass()
